package org.msh.tb.reports2.variables;

import org.msh.reports.filters.FilterOperation;
import org.msh.reports.filters.ValueHandler;
import org.msh.reports.query.SQLDefs;
import org.msh.tb.entities.enums.InfectionSite;
import org.msh.tb.entities.enums.TbField;

/**
 * A variable that handles all types of TB case pulmonary
 *  
 * @author Mauricio Santos
 *
 */
public class PatientRefToVariable extends FieldValueVariable {

	public PatientRefToVariable() {
		super("refto", "MedicalExamination.ReferredTo", "tbcasebd.PATIENTREFTO_ID", TbField.MEDEXAM_REFTOTYPE);
	}

	/* (non-Javadoc)
	 * @see org.msh.tb.reports2.VariableImpl#prepareVariableQuery(org.msh.reports.query.SQLDefs)
	 */
	@Override
	public void prepareVariableQuery(SQLDefs def, int iteration) {
		super.prepareVariableQuery(def, iteration);
	}

	/* (non-Javadoc)
	 * @see org.msh.tb.reports2.VariableImpl#prepareFilterQuery(org.msh.reports.query.SQLDefs, org.msh.reports.filters.FilterOperation, java.lang.Object)
	 */
	@Override
	public void prepareFilterQuery(SQLDefs def, FilterOperation oper, ValueHandler value) {
		super.prepareFilterQuery(def, oper, value);
	}

}
